/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBModuleGallery = Object.create(STBModule.prototype);

STBModuleGallery.name = "ModuleGallery";
STBModuleGallery.initPlugin = function() {

	var el=jQuery(".gallery-ajax:not(.__done)");

	if (el.length) {
		el.each(function() {
		
			var item = jQuery(this);

			item.click(function(e) {
				e.preventDefault();			

				var images = jQuery.getJSON(
					item.attr("data-json"), 
					function(msg) {

						if ((msg != null) && (msg.length > 0))	{
							item.lightGallery({
								dynamic: true,
								dynamicEl: msg
							});
						}
					}
				);
			});


			

			jQuery(this).addClass("__done");
		});	
	}
}

STBModuleGallery.runOnReady = function() {
	STBModuleGallery.initPlugin();
}

STBModuleGallery.runOnContentUpdate = function() {
	STBModuleGallery.initPlugin();
}

site.registerModule(STBModuleGallery);